% file for iteration algorithm, optimzation problem P1
function [gamma2,L,delta,R,obj1] = Optimization_P1(A,B,F,D,C,Mc,Nc,beta1,beta2,K,Rk,Sk) 

[n,m] = size(B);
[~,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);


delta = sqrt(min(eig(inv(Sk)))) - eps;
Nc = delta*Nc;
Mc = 1/delta*Mc;

Ce = eye(n+2*q);
Be = [-K pinv(B)*F zeros(m,q)];

% Augmented system
A_bar = [A F zeros(n,q); zeros(q,n) zeros(q,q) eye(q); zeros(q,n) zeros(q,q) zeros(q,q)];
C_bar = [C zeros(p,q) zeros(p,q)];
D_bar = [D zeros(n,q); zeros(q,l) zeros(q,q); zeros(q,l) eye(q)];

Mc_bar = [Mc; zeros(2*q,n)];


%%%%%%%%%% LMI1
Q0 = sdpvar(n+2*q,n+2*q);
Y0 = sdpvar(n+2*q,p);
gamma20 = sdpvar(1,1);

LMI1 = blkvar();
LMI1(1,1) = (Q0*A_bar - Y0*C_bar)+(Q0*A_bar- Y0*C_bar)';
LMI1(1,2) = Q0*D_bar;
LMI1(1,3) = Ce';
LMI1(2,2) = -gamma20*eye(l+q);
LMI1(3,3) = -gamma20*eye(n+2*q);
LMI1 = sdpvar(LMI1);

%%%%%%%%%%%%%%% LMI2
R0 = sdpvar(m,m);

LMI2 = blkvar();
LMI2(1,1) = (Q0*A_bar- Y0*C_bar)+(Q0*A_bar - Y0*C_bar)';
LMI2(1,3) = Q0*Mc_bar;
LMI2(1,4) = Be';
LMI2(1,5) = Be';

LMI2(2,2) = Nc'*Nc - inv(Sk);

LMI2(3,3) = -eye(n);
LMI2(4,4) = -R0;
LMI2(5,5) = -Rk;

LMI2 = sdpvar(LMI2);

const = [];
const = [const, gamma20 >= eps];
const = [const, Q0 >= eps*eye(n+2*q)];
const = [const, R0 >= eps*eye(m)];
const = [const, LMI1 <= -eps*eye(2*(n+2*q)+(l+q))];
const = [const, LMI2 <= -eps*eye((n+2*q)+n+n+m+m)];

obj = beta1*gamma20 + beta2*trace(R0);

ops = sdpsettings('solver','mosek','verbose',0);
optimize(const,1.0e-6*obj,ops);

L = inv(value(Q0))*value(Y0);
gamma2 = value(gamma20);
R = value(R0);

obj1 = value(1.0e-6*obj);
